/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Controller  ctrl ; // character controller
Mshg        mshg ; //          mesh group (used for rendering)
Phsg        phsg ; // physical mesh group (used for collisions)
Memb<Actor> actor; // container of actors that will be created out of 'phsg'
/******************************************************************************/
void InitPre()
{
   App.name="Physical meshes";
   App.flag=APP_MS_EXCLUSIVE;
   IOPath="../data/";
   PakAdd("engine.pak");
   D.full(true).sync(true);
}
Bool Init()
{
   Cam.dist=6;
   Physics.create();
   
   ctrl.create(Capsule(0.4,1.7,Vec(0,1,0))); // create character controller

   mshg.load  ("obj/terrain/0.mshg"); // load terrain Mshg
   phsg.create(mshg);                 // create physical body group (Phsg) from 'mshg'
   FREPA(phsg)                        // for all physical bodies (Phys) inside 'phsg'
   {
      Actor &a=actor.New();   // create new  Actor in container
      a.create(phsg.phys[i]); // create that Actor from phsg.phys[i]
   }
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button

   Physics.sim().get();

   // update controller (move on WSAD keys, crouch on Shift key, jump on Space key)
   Flt s=3;
   Vec vel(0,0,0);
   if(Kb.b(KB_W))vel+=!PointOnPlane(Cam.matrix.z,Vec(0,1,0))*s;
   if(Kb.b(KB_S))vel-=!PointOnPlane(Cam.matrix.z,Vec(0,1,0))*s;
   if(Kb.b(KB_A))vel-=!PointOnPlane(Cam.matrix.x,Vec(0,1,0))*s;
   if(Kb.b(KB_D))vel+=!PointOnPlane(Cam.matrix.x,Vec(0,1,0))*s;
   ctrl.update(vel, Kb.shift, Kb.bp(KB_SPACE) ? 3.5 : 0);

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear();
   LightDir(1,Cam.matrix.z).set();

   mshg   .draw(); // draw mesh
   Physics.draw(); // draw physics
}
/******************************************************************************/
